/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import jeresources.api.restrictions.Restriction;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

public class DimensionRestriction {
    public static final DimensionRestriction OVERWORLD = new DimensionRestriction((RegistryKey<World>)World.field_234918_g_);
    public static final DimensionRestriction NETHER = new DimensionRestriction((RegistryKey<World>)World.field_234919_h_);
    public static final DimensionRestriction END = new DimensionRestriction((RegistryKey<World>)World.field_234920_i_);
    public static final DimensionRestriction NONE = new DimensionRestriction();
    private Restriction.Type type;
    private RegistryKey<World> dimension;

    private DimensionRestriction() {
        this.type = Restriction.Type.NONE;
    }

    public DimensionRestriction(RegistryKey<World> type) {
        this(Restriction.Type.WHITELIST, type);
    }

    public DimensionRestriction(Restriction.Type type, RegistryKey<World> dimension) {
        this.type = type;
        this.dimension = dimension;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionRestriction) {
            DimensionRestriction other = (DimensionRestriction)obj;
            return this.type == other.type && this.dimension.equals(other.dimension);
        }
        return false;
    }

    public String toString() {
        return "Dimension: " + (this.type == Restriction.Type.NONE ? "None" : this.type.name() + " " + this.dimension.toString());
    }

    public int hashCode() {
        return this.type == Restriction.Type.NONE ? super.hashCode() : this.type.hashCode() ^ this.dimension.hashCode();
    }

    public String getDimensionName() {
        return this.type == Restriction.Type.NONE ? "all" : this.dimension.func_240901_a_().toString();
    }
}

